/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.viewer.statistics;

import filenet.sim.toolkit.viewer.VWSIMAnimatorDataModel;
import filenet.sim.toolkit.viewer.animation.VWSIMAnimationController;
import filenet.sim.toolkit.viewer.statistics.resources.VWSIMResource;
import java.text.DateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class VWSIMSimulationStatTableModel
extends AbstractTableModel {
    private static DateFormat s_dateFormat = DateFormat.getDateTimeInstance(0, 0);
    public static final int STAT_SIMULATION_NAME_COL = 0;
    public static final int STAT_SIMULATION_START_TIME_COL = 1;
    public static final int STAT_SIMULATION_END_TIME_COL = 2;
    public static final int STAT_SIMULATION_DURATION_COL = 3;
    protected VWSIMAnimatorDataModel m_animatorDataModel = null;
    private VWSIMAnimationController m_animationController = null;
    private Vector m_columnNames = new Vector();

    public VWSIMSimulationStatTableModel(VWSIMAnimationController animationController) {
        this.m_animationController = animationController;
        this.initColumnNames();
    }

    VWSIMAnimatorDataModel getDataModel() {
        if (this.m_animationController != null) {
            return this.m_animationController.getDataModel();
        }
        return null;
    }

    void initData() {
        this.fireTableDataChanged();
    }

    public Object getValueAt(int row, int col) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        if (row == 0) {
            switch (col) {
                case 0: {
                    if (this.getDataModel() != null) {
                        String name = this.getDataModel().getSimulationName();
                        if (name == null) {
                            name = this.getDataModel().getScenario().getName();
                        }
                        return name;
                    }
                    return null;
                }
                case 1: {
                    Date date;
                    if (this.m_animationController != null && (date = this.m_animationController.getSimulationStartTime()) != null) {
                        return s_dateFormat.format(date);
                    }
                    return null;
                }
                case 2: {
                    Date date;
                    if (this.m_animationController != null && (date = this.m_animationController.getSimulationEndTime()) != null) {
                        return s_dateFormat.format(date);
                    }
                    return null;
                }
                case 3: {
                    if (this.m_animationController != null) {
                        return this.m_animationController.getSimulationDuration();
                    }
                    return null;
                }
            }
        }
        return null;
    }

    protected void initColumnNames() {
        this.m_columnNames.addElement(VWSIMResource.s_simulation_col);
        this.m_columnNames.addElement(VWSIMResource.s_start_time_col);
        this.m_columnNames.addElement(VWSIMResource.s_end_time_col);
        this.m_columnNames.addElement(VWSIMResource.s_duration_col);
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return String.class;
            }
        }
        return String.class;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public int getRowCount() {
        return 1;
    }

    public int getColumnCount() {
        return this.m_columnNames.size();
    }

    public String getColumnName(int col) {
        if (col < this.getColumnCount()) {
            return (String)this.m_columnNames.elementAt(col);
        }
        return null;
    }

    void releaseResources() {
        this.m_animationController = null;
        if (this.m_columnNames != null) {
            this.m_columnNames.removeAllElements();
            this.m_columnNames = null;
        }
    }
}

